package data.console.commands;

import data.scripts.campaign.events.SWP_IBBTracker;
import data.scripts.campaign.missions.SWP_FamousBountyEvent;
import data.scripts.campaign.missions.SWP_FamousBountyEvent.FamousBountyStage;
import org.lazywizard.console.BaseCommand;
import org.lazywizard.console.CommonStrings;
import org.lazywizard.console.Console;

public class SWP_FamousBountyStage implements BaseCommand {

    @Override
    public CommandResult runCommand(String args, CommandContext context) {
        if (context != CommandContext.CAMPAIGN_MAP) {
            Console.showMessage(CommonStrings.ERROR_CAMPAIGN_ONLY);
            return CommandResult.WRONG_CONTEXT;
        }

        if (args.isEmpty()) {
            return CommandResult.BAD_SYNTAX;
        }

        int stageNum;

        try {
            stageNum = Integer.parseInt(args);
        } catch (NumberFormatException ex) {
            Console.showMessage("Error: stage must be a number!");
            return CommandResult.BAD_SYNTAX;
        }

        if (stageNum < 0 || stageNum > SWP_FamousBountyEvent.MAX_BOUNTY_STAGE) {
            Console.showMessage("Error: stage must be between 0 and " + SWP_FamousBountyEvent.MAX_BOUNTY_STAGE + "!");
            return CommandResult.ERROR;
        }

        FamousBountyStage stage = SWP_IBBTracker.getStage(stageNum);
        if (stage != null && !stage.mod.isLoaded()) {
            switch (stage.mod) {
                case JUNK_PIRATES:
                    Console.showMessage("Error: selected stage requires Junk Pirates!");
                    break;
                case TIANDONG:
                    Console.showMessage("Error: selected stage requires Tiandong Heavy Industries!");
                    break;
                case SHADOWYARDS:
                    Console.showMessage("Error: selected stage requires Shadowyards Reconstruction Authority!");
                    break;
                case IMPERIUM:
                    Console.showMessage("Error: selected stage requires Interstellar Imperium!");
                    break;
                case TEMPLARS:
                    Console.showMessage("Error: selected stage requires The Knights Templar!");
                    break;
                case BLACKROCK:
                    Console.showMessage("Error: selected stage requires Blackrock Drive Yards!");
                    break;
                case CABAL:
                    Console.showMessage("Error: selected stage requires Underworld!");
                    break;
                case CITADEL:
                    Console.showMessage("Error: selected stage requires Citadel!");
                    break;
                case DIABLE:
                    Console.showMessage("Error: selected stage requires Diable Avionics!");
                    break;
                case EXIGENCY:
                    Console.showMessage("Error: selected stage requires Exigency!");
                    break;
                case MAYORATE:
                    Console.showMessage("Error: selected stage requires Mayorate!");
                    break;
                case ORA:
                    Console.showMessage("Error: selected stage requires Outer Rim Alliance!");
                    break;
                case SCY:
                    Console.showMessage("Error: selected stage requires Scy Nation!");
                    break;
                default:
                    break;
            }
            return CommandResult.ERROR;
        }
        if (stage == null || !SWP_IBBTracker.getTracker().isStageAllowed(stage)) {
            Console.showMessage("Error: invalid stage!");
            return CommandResult.ERROR;
        }

        SWP_IBBTracker.getTracker().reset();
        for (int i = 0; i < stageNum; i++) {
            FamousBountyStage s = SWP_IBBTracker.getStage(i);
            SWP_IBBTracker.getTracker().reportStageCompleted(s);
        }

        Console.showMessage("Famous bounty stage set to " + stageNum + " (" + stage.firstName + " " + stage.lastName
                + ").");
        return CommandResult.SUCCESS;
    }
}
